%% This function is used to adjust the tolerance of constraints
function [tolerance_i] = get_tolerance(h, tolerance_i, tolerance_f, fes, h_sum)
% h equality constraint value, tolerance_i dynamic equality tolerance, tolerance_f minimum equality tolerance, 
% The remaining number of evaluations allowed for adjustment in fes, and the minimum value of constraint violation in the h-sum equation
	ps = size(h, 1); % The number of population
    h_sum = h_sum == 0; 
	decay = (tolerance_f ./ tolerance_i) .^ (ps / fes);
    decay = decay .* h_sum;        
    decay = decay + (~h_sum);
	tolerance_i = tolerance_i .* decay;
	tolerance_i = max(tolerance_i, tolerance_f); 
end